# to autoload this file
proc m2ShellUse.tcl {} {}

#===============================================================================
#  Communication with shell, for launching and compiler error display  #
#===============================================================================

namespace eval M2 {}

# force loading of mode or variables won't be defined
M2load	
set m2ErrRing ""

# This procedure is called by the event handlers. It could contain any 
# script to be executed.  However, currently (March 89), MacMETH shell 
# as well as the RAMSES shell do not use anything else than AlphaEdit,
# which in its current implementation writes only openWorkFiles into
# the "token.ALPHA" file. Thus omitting the use of this proc speeds 
# things up.
proc handleM2TokenFile {} {
	global M2TokenFile
#	alertnote "In handleM2TokenFile"
	if {[file exists "$M2TokenFile"]} {
		source  "$M2TokenFile"
		removeFile "$M2TokenFile"
	}
}



# Set up responding to events received from the Modula-2 shell
# In particular the class "oM2f" (stands for open M2 files)
# with event "comp" (after compilation) lets you display
# automatically the involved work files and show the errors
# Implementation of Alpha command eventHandler did only
# really work after version "Alpha (68k) 6.2b2, Jun 8, 1996"
# Appears to have worked in the PPC version of Alpha always
# ------------------------------------------------------------

proc checkForErrALPHA {} {
	global M2ErrFile
	if {[info exists M2ErrFile] && [file exists $M2ErrFile]} then {
		return 1
	} else {
		return 0
	}
}

proc checkForTokenALPHA {} {
	global M2TokenFile
	if {[info exists M2TokenFile] && [file exists $M2TokenFile]} then {
		return 1
	} else {
		return 0
	}
}

proc checkForM2Shell {} {
	global M2ShellName
	if {[info exists M2ShellName] && [file exists $M2ShellName]} then {
		return 1
	} else {
		return 0
	}
}

proc checkForErrDOKFile {} {
	global M2errDOKFile
	if {[info exists M2errDOKFile] && [file exists $M2errDOKFile]} then {
		return 1
	} else {
		return 0
	}
}

# The initially used eventhandler to ensure proper configuration if launched via M2 shell
proc m2EventHandler {dummy} {
    installAEventHandler m2EventHandlerSimple 0
	if {![checkForErrALPHA] | ![checkForM2Shell] | ![checkForErrDOKFile]} then {
		checkM2Configuration
	}
	# Alternative for handling more complicated cases than just M2::openWorkFiles
	# handleM2TokenFile
    M2::openWorkFiles
}

# Normally used eventhandler, more efficient, since does no configuration checking anymore
proc m2EventHandlerSimple {dummy} {
	# Alternative for handling more complicated cases than just M2::openWorkFiles
	# handleM2TokenFile
    M2::openWorkFiles
}


proc installAEventHandler {theHandler verbous} {
	global curAlphaV
	set class "oM2f"
	set event "comp"
	# You can't compare with '6.2b2' very effectively.
	set firstAlphaWorkingV "6.2"
	if {![info exists curAlphaV] || ($curAlphaV == "")} then {return}
	if {$curAlphaV >= $firstAlphaWorkingV} then {
	    message "Modula-2 working files are automatically opened in this version of Alpha"
	    # Here comes now the actual declaration
		eventHandler $class $event "$theHandler"
	} else {
		if $verbous {
		    set msg "Modula-2 working files are NOT automatically opened in this outdated "
		    set msg "$msg version of Alpha! "
		    set msg "$msg Please upgrade to a version >=$firstAlphaWorkingV."
			alertnote $msg
		}	
	}
}


#================================================================================
proc callM2Shell {} {
	global M2ShellName
	launch  -f "$M2ShellName"
}

proc reportOnShellLaunchFail {} {
	global M2ShellName
	beep
	set msg "Call of M2 shell failed!\r"
	if {[info exists M2ShellName]} then { 
		set testfile $M2ShellName 
	} else {
		set testfile ""
	}
	if {![file exists "$testfile"]} then {
		if {"$M2ShellName" == ""} then {
			append msg "M2 mode works fully only if MacMETH or RAMSES are installed. Both appear to be missing"
			alertnote "${msg}." 
		} else {
			append msg "Hint: Open a scratch window, enter M2 mode and try menu M2 -> Configure launching"
			alertnote "$msg." 
		}
	} else {	
		append msg "Please enter at least once M2 mode, or reconfigure launching"
	    alertnote "$msg, and/or make sure sufficient RAM is available."
	}
}

proc launchShell {} {
	if {[catch callM2Shell]} { reportOnShellLaunchFail }
}

proc launchShellAndSimulate {} {
	global M2ShellName
	if {[info exists M2ShellName]} then { 
		set shellName [file tail $M2ShellName]
	    # requires a dummy string in order to avoid dialog for selecting the
	    # receiving application
	  	if {[catch {dosc -n "$shellName" -k 'DMEv' -e 'COMP' -r -s "dumy"}]} then {
	  	}
	 	# The following alternative does not work, althouth it should (Bug in Alpha)
	    # dosc -c "RAMS" -k 'DMEv' -e 'COMP' -r -s "gaga"
        # dosc -n $appName -k 'aevt' -e 'odoc' -r -f $currentWin
	}
	if {[catch callM2Shell]} { reportOnShellLaunchFail }
}

proc AskRAMSESToOpenFile {relPath moduleName} {
	global M2ShellName
	set module [file dirname $M2ShellName]
    set module "$module$relPath$moduleName"
	set shellName [file tail $M2ShellName]
 	dosc -n "$shellName" -k 'aevt' -e 'odoc' -r -f $module
	if {[catch callM2Shell]} { reportOnShellLaunchFail }
}

# AskRAMSESToOpenFile ":" "User.Profile"
# AskRAMSESToOpenFile ":Work:" "Logistic.OBM"
# AskRAMSESToOpenFile ":Work:" "Logistic.DAT"



# Reporting that end of this script has been reached
message "m2ShellUse.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
    alertnote "m2ShellUse.tcl for Programing in Modula-2 loaded"
}
